' Classe abstraite.
Public MustInherit Class Shape

    Protected mPetName As String

    ' Tous les objets enfants doivent dfinir par eux-mme
    ' ce que signifie tre dessin.
    Public MustOverride Sub Draw()

    Public Property PetName() As String
        Get
            Return mPetName
        End Get
        Set(ByVal Value As String)
            mPetName = Value
        End Set
    End Property

    ' Constructeurs.
    Public Sub New()
        mPetName = "Pas de nom"
    End Sub

    Public Sub New(ByVal s As String)
        mPetName = s
    End Sub
End Class

Public Class Circle
    Inherits Shape

    Public Sub New()
    End Sub
    Public Sub New(ByVal n As String)
        MyBase.New(n)
    End Sub

    Public Overrides Sub Draw()
        Console.WriteLine("Dessin de " + PetName + " le cercle")
    End Sub

    Public Overridable Sub RollShape()
        Console.WriteLine("Tourner le cercle")
    End Sub
End Class

Public Class Oval
    Inherits Circle

    Public Sub New()
        MyBase.PetName = "Joe"
    End Sub

    Public Overrides Sub Draw()
        Console.WriteLine("Dessin de {0} l'ovale", PetName)
    End Sub

    ' Cacher l'implmentation de la classe de base si l'on cre un ovale.
    Public Shadows Sub RollShape()
        Console.WriteLine("On tourne l'ovale...")
        Console.WriteLine("FLOP...")
    End Sub

    Public Sub PushOval()
        Draw()
        RollShape()
    End Sub
End Class

Public Class Hexagon
    Inherits Shape

    Public Sub New()
    End Sub

    Public Sub New(ByVal name As String)
        MyBase.New(name)
    End Sub

    Public Overrides Sub Draw()
        Console.WriteLine("Dessin de {0} l'hexagone", PetName)
    End Sub
End Class